<?php

namespace VM\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;
use VM\ApiBundle\Entity\CompanyBankServiceOption;

/**
 * CompanyBankServiceOptionsRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class CompanyBankServiceOptionsRepository extends EntityRepository
{
    /**
     * @param $companyId
     * @return CompanyBankServiceOption|null
     */
    public function getCompanyCurrentAccountOption($companyId)
    {
        $QueryBuilder = $this->createQueryBuilder('cbso')
            ->leftJoin('cbso.option', 'bso')
            ->leftJoin('bso.bankService', 'bs')
            ->andWhere('cbso.companyId = :companyId')
            ->andWhere('bs.symbol = :symbol')
            ->setParameter('companyId', $companyId)
            ->setParameter('symbol', 'CURRENT_ACCOUNT')
            ->setMaxResults(1)
        ;

        return $QueryBuilder->getQuery()->getOneOrNullResult();
    }


    public function changeCurrentAccountValue($currentAccountId, $value)
    {
        $this->getConnection()->executeUpdate("UPDATE VM\ApiBundle\Entity\CompanyBankServiceOption SET value = value + ? WHERE id = ?", array($value, $currentAccountId));
    }
}
